/*
	BDS Welcome Page - XML Document Routines

	Copyright (c) 2004, 2005 Borland Software Corporation

	Written by Daniel Wischnewski, Borland SE Germany.
	Co-Admin of www.delphipraxis.net -- The German Delphi Community
	Email: dwischnewski@gatenetwork.com
*/

function getItemValue(item, tag)
{
	var valueItem;
	
	if (item != null)
	{
		valueItem = item.selectSingleNode(tag);
		if (valueItem != null)
		{
			return valueItem.text;
		} else {
			return '';
		}
	} else {
		return '';
	}
}

function getDateItemValue(item, tag)
{
	var datevalue;
	var utcdate;

	datevalue = getItemValue(item, tag);
	if (datevalue != '')
	{
		utcdate = new Date(Date.parse(datevalue));
		return utcdate.toLocaleString();
	}
	return datevalue;
}

function getXmlDoc()
{
	var xmlDoc;
	
	xmlDoc = new ActiveXObject('Microsoft.XMLDOM');
	xmlDoc.async = false;
	return xmlDoc;
}

function getXmlHttpDoc()
{
	var xmlDoc;

	xmlDoc = new ActiveXObject('Msxml2.ServerXMLHTTP.4.0');
	return xmlDoc;
}

function loadXmlDoc(fileName)
{
	var xmlDoc;

	xmlDoc = getXmlDoc();
	xmlDoc.load(fileName);
	return xmlDoc;
}

function loadXmlDocSafe(fileName)
{
	var xmlDoc;

	xmlDoc = loadXmlDoc(fileName);
	if (xmlDoc.parseError.errorCode != 0)
	{
		xmlDoc.loadXML('<rss version="2.0" />');
	}
	return xmlDoc;
}

function getSubNode(xmlNode, nodeName)
{
	var subNode;

	subNode = xmlNode.selectSingleNode(nodeName);
	if (subNode == null)
	{
		subNode = xmlNode.appendChild(xmlNode.ownerDocument.createNode(1, nodeName, ''));
	}
	return subNode;
}

function getSubNodeEx(xmlNode, nodeName, attrName, attrValue)
{
	var subNode;
	var attr;
	var XSL;

	XSL = nodeName + '[@' + attrName + '="' + attrValue + '"]';
	subNode = xmlNode.selectSingleNode(XSL);
	if (subNode == null)
	{
		subNode = xmlNode.appendChild(xmlNode.ownerDocument.createNode(1, nodeName, ''));
		attr = xmlNode.ownerDocument.createNode(2, attrName, '');
		attr.text = attrValue;
		subNode.attributes.setNamedItem(attr);
	}
	return subNode;
}

function setAttrValue(xmlNode, attrName, attrValue)
{
	var attr;

	attr = xmlNode.ownerDocument.createNode(2, attrName, '');
	attr.text = attrValue;
	xmlNode.attributes.setNamedItem(attr);
}

function getSettingsNode(xmlDoc)
{
	return getSubNode(xmlDoc.documentElement, 'settings');
}

function loadLocalXmlDoc(fileName)
{
	var xmlFile;

	xmlFile = xmlPath + fileName;
	return loadXmlDoc(xmlFile);
}

function loadLocalXslDoc(fileName)
{
	var xslFile;

	xslFile = xslPath + fileName;
	return loadXmlDoc(xslFile);
}

